﻿<%@ Page Language="C#" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">
    //My LiveChat Id
    string MyLiveChatID = "92252608";
    string UserName = "test user";
    string UserKey = "test key";

    //The encrypt key should be the same as setting on mylivechat account console.
    string UserKeyEncryptBasicKey = "mytestkey";
    string UserKeyEncryptMode = "Basic";
    
    protected override void OnInit(EventArgs e)
	{
		base.OnInit(e);

        if (UserKeyEncryptMode == "Basic")
        {
            UserKey = BasicEncrypt(UserKey, UserKeyEncryptBasicKey); 
        }
    }

    #region MyLiveChat Encrypt Algorithm
    int EncryptLoopCount = 4;
    public int[] MakeArray(string str, bool random)
    {
        int len = (int)Math.Pow(2, Math.Floor(Math.Log(str.Length, 2)) + 1) + 8;
        if (len < 32) len = 32;

        int[] arr = new int[len];

        if (random)
        {
            Random r = new Random();
            for (int i = 0; i < arr.Length; i++)
                arr[i] = str[r.Next() % str.Length];

            int start = 1 + r.Next() % (len - str.Length - 2);

            for (int i = 0; i < str.Length; i++)
                arr[start + i] = str[i];

            arr[start - 1] = 0;
            arr[start + str.Length] = 0;
        }
        else
        {
            for (int i = 0; i < arr.Length; i++)
                arr[i] = str[i % str.Length];
        }

        return arr;
    }

    public string BasicFormat(int[] vals)
    {
        StringBuilder sb = new StringBuilder();
        foreach (int i in vals)
        {
            if (sb.Length > 0)
                sb.Append("-");
            sb.Append(i);
        }
        return sb.ToString();
    }

    public string BasicEncrypt(string data, string encryptkey)
    {
        if (string.IsNullOrEmpty(data))
            throw (new ArgumentNullException("data"));
        if (string.IsNullOrEmpty(encryptkey))
            throw (new ArgumentNullException("encryptkey"));

        int[] vals = MakeArray(data, true);
        int[] keys = MakeArray(encryptkey, false);

        for (int t = 0; t < EncryptLoopCount; t++)
        {
            for (int i = 0; i < vals.Length; i++)
            {
                int v = vals[i];
                int im = (v + i) % 5;

                for (int x = 0; x < vals.Length; x++)
                {
                    if (x == i)
                        continue;
                    if (x % 5 != im)
                        continue;

                    for (int y = 0; y < keys.Length; y++)
                    {
                        int k = keys[y];
                        if (k == 0)
                            continue;

                        vals[x] += v % k;
                    }
                }
            }
        }
        return BasicFormat(vals);
    }
    #endregion
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>MyLiveChat Integration Basic Encryption Mode Demo</title>
    <style type="text/css">
        html,body {margin:0px; padding:0px;}
        body {background:#eeeeee; font-family:MS Sans Serif; font-size:13px;}
        
        .section {font-weight:bold;}
        ul { list-style-type:decimal;}
        ul div {margin-top:10px;}
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <div style="text-align:center;">
        <div style="width:800px; margin:auto; margin-top:20px; padding:10px; border:1px solid #dbdbdb; text-align:left; background:white;">
        <h3>
            MyLiveChat Integration Basic Encryption Mode Demo for C#
        </h3>
        <div>
            <ul>
                <li>
                    <div class="section">Config MyLiveChat Integration Settings</div>
                    <div>
                        Login to MyLiveChat, and go to Account Console.
                        Click <b>Advanced Topics -> Integration</b> Settings menu on the left.
                        <br /><br />
                        Select Basic mode, input an encryption key you used in this demo.
                        <p>
                            <img src="images/img_1.gif" alt="img 1" />
                        </p>
                    </div>
                </li>
                <li>
                    <div class="section">Encrypt user key, insert MyLiveChat code, set user key by MyLiveChat javascript API</div>
                    <div style="padding:3px; border:solid 1px #dddddd;">                        
                        <span style='color:#009900; '>&lt;!--This is mylivechat html code--></span>
                        <br />
                        <span style='color:#0000FF; '>&lt;</span><span style='color:#800000; font-weight:bold; '>script</span> <span style="color: #FF0000">type</span><span style="color: #0000CC">="text/javascript"</span>
                            <span style="color: #FF0000">src</span><span style="color: #0000CC">="https://www.mylivechat.com/chatbutton.aspx?hccid=</span><span style="color: #CC0000">MyLiveChatID</span><span style="color: #0000CC">"</span><span style='color:#0000FF; '>&gt;</span>
                        <span style='color:#0000FF; '>&lt;/</span><span style='color:#800000; font-weight:bold; '>script</span><span style='color:#0000FF; '>&gt;</span>
                        <br />
                        <span style='color:#0000FF; '>&lt;</span><span style='color:#800000; font-weight:bold; '>script</span> <span style="color: #FF0000">type</span><span style="color: #0000CC">="text/javascript"</span><span style='color:#0000FF;'>&gt;</span>
                        <br />
function MyLiveChat_OnInit() { <br/>
                        &nbsp;&nbsp;&nbsp;&nbsp;MyLiveChat_SetUserName("USERNAME", "USERKEY");
                        <br />
} <br/>
                        <span style='color:#0000FF; '>&lt;/</span><span style='color:#800000; font-weight:bold; '>script</span><span style='color:#0000FF; '>&gt;</span>
                        
                    </div>
                </li>
                <li>
                    <div class="section">Test</div>
                    <div>
                        <script type="text/javascript"src="https://www.mylivechat.com/chatbutton.aspx?hccid=<%=MyLiveChatID %>"></script>
                        <script type="text/javascript">
			function MyLiveChat_OnInit() {
                            MyLiveChat_SetUserName("<%=UserName %>", "<%=UserKey %>");
			}
                        </script>
                    </div>
                </li>
            </ul>
        </div>
    </div>
    </div>
    </form>
</body>
</html>
