<?php
$MyLiveChatID = "92252608";
$UserName = "test user";
$UserKey = "test key";

//The encrypt key should be the same as setting on mylivechat account console.
$UserKeyEncryptBasicKey = "mytestkey";
$UserKeyEncryptMode = "Basic";

function GetEncrypt($data, $encrymode,$encrykey)
{
	if($encrymode=="Basic")
		return BasicEncrypt($data,$encrykey);
	return $data;
}

//MyLiveChat Encrypt Algorithm
function BasicEncrypt($data, $encryptkey)
{
	$EncryptLoopCount = 4;

	$vals = MakeArray($data, true);
	$keys = MakeArray($encryptkey, false);

	$len = sizeof($vals);
	$len2 = sizeof($keys);

	for ($t = 0; $t < $EncryptLoopCount; $t++)
	{
		for ($i = 0; $i < $len; $i++)
		{
			$v = $vals[$i];
			$im = ($v + $i) % 5;

			for ($x = 0; $x < $len; $x++)
			{
				if ($x == $i)
					continue;
				if ($x % 5 != $im)
					continue;

				for ($y = 0; $y <$len2; $y++)
				{
					$k = $keys[$y];
					if ($k == 0)
						continue;

					$vals[$x] += $v % $k;
				}
			}
		}
	}
	return implode('-', $vals);
}

function MakeArray($str, $random)
{
	$len = pow(2, floor(log(strlen($str), 2)) + 1) + 8;
	if ($len < 32) $len = 32;

	$arr = Array();
	$strarr = str_split($str);
	if ($random==true)
	{
		for ($i = 0; $i < $len; $i++)
			$arr[] = ord($strarr[rand() % strlen($str)]);

		$start = 1 + rand() % ($len - strlen($str) - 2);

		for ($i = 0; $i < strlen($str); $i++)
			$arr[$start + $i] = ord($strarr[$i]);

		$arr[$start - 1] = 0;
		$arr[$start + strlen($str)] = 0;
	}
	else
	{
		for ($i = 0; $i < $len; $i++)
			$arr[] = ord($strarr[$i % strlen($str)]);
	}

	return $arr;
}

function EncodeJScript($str)
{
	$chars="0123456789ABCDEF";
	$chars = str_split($chars);

	$sb = "";
	$l = strlen($str);
	$strarr = str_split($str);
	for ($i = 0; $i < $l; $i++)
	{
		$c = $strarr[$i];
		if ($c == '\\' || $c == '"' || $c == '\'' || $c == '>' || $c == '<' || $c == '&' || $c == '\r' || $c == '\n')
		{
			if ($sb == "")
			{
				if ($i > 0)
				{
					$sb .= substr($str, 0, $i);
				}
			}
			if ($c == '\\')
			{
				$sb.="\\x5C";
			}
			else if ($c == '"')
			{
				$sb.="\\x22";
			}
			else if ($c == '\'')
			{
				$sb.="\\x27";
			}
			else if ($c == '\r')
			{
				$sb.="\\x0D";
			}
			else if ($c == '\n')
			{
				$sb.="\\x0A";
			}
			else if ($c == '<')
			{
				$sb.="\\x3C";
			}
			else if ($c == '>')
			{
				$sb.="\\x3E";
			}
			else if ($c == '&')
			{
				$sb.="\\x26";
			}
			else
			{
				$code = $c;
				$a1 = $code & 0xF;
				$a2 = ($code & 0xF0) / 0x10;
				$sb.="\\x";
				$sb.=$chars[$a2];
				$sb.=$chars[$a1];
			}
		}
		else if ($sb != "")
		{
			$sb .= $c;
		}
	}
	if ($sb != "")
		return $sb;
	return $str;
}
?>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>MyLiveChat Integration Basic Encryption Mode Demo</title>
    <style type="text/css">
        html,body {margin:0px; padding:0px;}
        body {background:#eeeeee; font-family:MS Sans Serif; font-size:13px;}
        
        .section {font-weight:bold;}
        ul { list-style-type:decimal;}
        ul div {margin-top:10px;}
    </style>
</head>
<body>
    <form id="form1">
    <div style="text-align:center;">
        <div style="width:800px; margin:auto; margin-top:20px; padding:10px; border:1px solid #dbdbdb; text-align:left; background:white;">
        <h3>
            MyLiveChat Integration Basic Encryption Mode Demo for php
        </h3>
        <div>
            <ul>
                <li>
                    <div class="section">Config MyLiveChat Integration Settings</div>
                    <div>
                        Login to MyLiveChat, and go to Account Console.
                        Click <b>Advanced Topics -> Integration</b> Settings menu on the left.
                        <br /><br />
                        Select Basic mode, input an encryption key you used in this demo.
                        <p>
                            <img src="images/img_1.gif" alt="img 1" />
                        </p>
                    </div>
                </li>
                <li>
                    <div class="section">Encrypt user key, insert MyLiveChat code, set user key by MyLiveChat javascript API</div>
                    <div style="padding:3px; border:solid 1px #dddddd;">                        
                        <span style='color:#009900; '>&lt;!--This is mylivechat html code--></span>
                        <br />
                        <span style='color:#0000FF; '>&lt;</span><span style='color:#800000; font-weight:bold; '>script</span> <span style="color: #FF0000">type</span><span style="color: #0000CC">="text/javascript"</span>
                            <span style="color: #FF0000">src</span><span style="color: #0000CC">="https://www.mylivechat.com/chatbutton.aspx?hccid=</span><span style="color: #CC0000">MyLiveChatID</span><span style="color: #0000CC">"</span><span style='color:#0000FF; '>&gt;</span>
                        <span style='color:#0000FF; '>&lt;/</span><span style='color:#800000; font-weight:bold; '>script</span><span style='color:#0000FF; '>&gt;</span>
                        <br />
                        <span style='color:#0000FF; '>&lt;</span><span style='color:#800000; font-weight:bold; '>script</span> <span style="color: #FF0000">type</span><span style="color: #0000CC">="text/javascript"</span><span style='color:#0000FF;'>&gt;</span>
                        <br />
						function MyLiveChat_OnInit() { <br/>
                        &nbsp;&nbsp;&nbsp;&nbsp;MyLiveChat_SetUserName("USERNAME", "USERKEY");
                        <br />
						} <br/>
                        <span style='color:#0000FF; '>&lt;/</span><span style='color:#800000; font-weight:bold; '>script</span><span style='color:#0000FF; '>&gt;</span>
                        
                    </div>
                </li>
                <li>
                    <div class="section">Test</div>
                    <div>
                        <script type="text/javascript"src="https://www.mylivechat.com/chatbutton.aspx?hccid=<?php echo $MyLiveChatID ?>"></script>
                        <script type="text/javascript">
						function MyLiveChat_OnInit() {
                            MyLiveChat_SetUserName('<?php echo EncodeJScript($UserName) ?>', '<?php echo EncodeJScript(GetEncrypt($UserKey,$UserKeyEncryptMode,$UserKeyEncryptBasicKey)) ?>');
						}
                        </script>
                    </div>
                </li>
            </ul>
        </div>
    </div>
    </div>
    </form>
</body>
</html>